***********************************
* Wahlen und Wähler 2017          *
* Kapitel 9: Replikation Tabellen *
***********************************
* Datenbasis: FORSA-Panelbefragung (Wahlkampf 2017)
***************************************************
clear
cd "C:\Users\sprin\Seafile\Meine Bibliothek\Aufsätze\Forsa"
use data_ch7

* Aufbereitung Variablen für Tabellen 2-5 
*******************************************

* Kandidateneigenschaften (Tab. 2 + 4)

foreach a of numlist 2 3 {
foreach b of numlist 1/7 {
foreach c in I II III IV  {
mvdecode f1`a'_`b'_`c', mv(6)  								
// für Tab. 2 + 4: Missings für alle Variablen zu Kandidateneigenschaften 
// festlegen: 6 = "k.A."
gen f1`a'_`b'_`c'Bi = 1 if f1`a'_`b'_`c' == 4 | f1`a'_`b'_`c' == 5	
replace f1`a'_`b'_`c'Bi = 0 if f1`a'_`b'_`c' < 4
// für Tab. 2: Dichotomisierung der Variablen zu Kandidateneigenschaften 
}
}
}
// Zum Verständnis der Schleifen:
// a: Die Variablen f12 (f13) beziehen sich auf Merkel (Schulz).
// b: Der mittlere Part des Variablennamens gibt an, um welche Eigenschaft es 
// geht (bspw. 1 = Führungsqualitäten)
// c: Die römischen Ziffern weisen aus, auf welche Panelwelle sich eine Variable
// bezieht. 

foreach c in I II III IV  {
lab var f12_1_`c'Bi "Merkel: Führungsqualität"
lab var f12_2_`c'Bi "Merkel: Gute Ideen für Deutschland"
lab var f12_3_`c'Bi "Merkel: Fähig, Probleme Deutschlands zu lösen"
lab var f12_4_`c'Bi "Merkel: Vertrauenswürdig"
lab var f12_5_`c'Bi "Merkel: Verständliche Sprache"
lab var f12_6_`c'Bi "Merkel: Engagierter Wahlkampf"
lab var f12_7_`c'Bi "Merkel: Angenehme Ausstrahlung"
lab var f13_1_`c'Bi "Schulz: Führungsqualität"
lab var f13_2_`c'Bi "Schulz: Gute Ideen für Deutschland"
lab var f13_3_`c'Bi "Schulz: Fähig, Probleme Deutschlands zu lösen"
lab var f13_4_`c'Bi "Schulz: Vertrauenswürdig"
lab var f13_5_`c'Bi "Schulz: Verständliche Sprache"
lab var f13_6_`c'Bi "Schulz: Engagierter Wahlkampf"
lab var f13_7_`c'Bi "Schulz: Angenehme Ausstrahlung"
}
lab def zus 1 "trifft zu" 0 "trifft nicht zu"
lab val *Bi zus 
// Labeln soeben gebildeter dichotomer Variablen zu Kandidateneigenschaften

* Kandidatenvergleich (Tab. 3)

foreach c in I II III IV {
recode f17_`c' (2 3=0) (4=.), gen(f17_am_`c') // 4 = "k.A"
recode f17_`c' (1 3=0) (2=1) (4=.), gen(f17_ms_`c')
recode f18_`c' (2 3=0) (4=.), gen(f18_am_`c')
recode f18_`c' (1 3=0) (2=1) (4=.), gen(f18_ms_`c')
cap recode f20_`c' (2 3=0) (4=.), gen(f20_am_`c') 
cap recode f20_`c' (1 3=0) (2=1) (4=.), gen(f20_ms_`c')
// "cap", weil f20 in Welle 1 nicht vorhanden (Vermeidung Abbruch, wenn c = I)
// Dichotomisierung der Variablen zum Kandidatenvergleich
}

foreach c in I II III IV  {
lab var f17_am_`c' "Merkel: beste Problemlösung"
lab var f18_am_`c' "Merkel: Kanzlerpräferenz"
cap lab var f20_am_`c' "Merkel: beste Wahlkampf"
lab var f17_ms_`c' "Schulz: beste Problemlösung"
lab var f18_ms_`c' "Schulz: Kanzlerpräferenz"
cap lab var f20_ms_`c' "Schulz: beste Wahlkampf"
}
lab def vergl_am 1 "Merkel" 0 "Schulz/keiner von beiden"
lab def vergl_ms 1 "Schulz" 0 "Merkel/keiner von beiden"
lab val *am* vergl_am
lab val *ms* vergl_ms
// Labeln soeben gebildeter dichotomer Variablen zum Kandidatenvergleich

* Parteiidentifikation (Tab. 4 + 5)

foreach c in I II IV {
recode f3_`c' (1 2=1) (3/9=0) (10=.), gen(piUnion`c') // 10 = "k.A."
recode f3_`c' (3=1) (1 2 4/9=0) (10=.), gen(piSPD`c') // 10 = "k.A."
}
// 1., 2., 4. Welle: Antwort auf Frage nach Parteiidentifikation in einer 
// Variable gespeichert

gen piUnionIII = 1 if f31_III == 1 | f32_III == 1
replace piUnionIII = 0 if f31_III == 0 & f32_III == 0
replace piUnionIII = . if f31_III != 1 & f32_III != 1 & f33_III != 1 ///
& f34_III != 1 & f35_III != 1 & f36_III != 1 & f37_III != 1 & f38_III !=1 ///
& f39_III != 1
gen piSPDIII = 1 if f33_III == 1
replace piSPDIII = 0 if f33_III == 0
replace piSPDIII = . if piUnionIII == .
// 3. Welle: Parteiidentifikation bereits zuvor in Dummies hinterlegt

foreach c in I II III IV {
lab var piSPD`c' "SPD: Parteididentifikation"
lab var piUnion`c' "Union: Parteiidentifikation"
}
lab def jn 1 "ja" 0 "nein"
lab val pi* jn
// Labeln soeben gebildeter dichotomer Variablen zu Kandidateneigenschaften

* Wahlabsicht (Tab. 5)

foreach c in I II III IV {
gen wUnion`c' = .
replace wUnion`c' = 1 if f7b_`c' == 1 | f7b_`c' == 2
replace wUnion`c' = 0 if f7b_`c' > 2 & f7b_`c' < 9
gen wSPD`c' = .
replace wSPD`c' = 1 if f7b_`c' == 3
replace wSPD`c' = 0 if f7b_`c' != 3 & f7b_`c' < 9
// Dichotomisierung der Variable zur Zweitstimme
}

foreach c in I II III IV {
lab var wSPD`c' "SPD: Wahlabsicht, Zweitstimme"
lab var wUnion`c' "Union: Wahlabsicht, Zweitstimme"
}
lab val w* jn

* Problemlösungskompetenz der Parteien (Tab. 5)

foreach c in I II III IV {
gen plUnion`c' = .
replace plUnion`c' = 1 if f15_`c' == 1
replace plUnion`c' = 0 if f15_`c' !=1 & f15_`c' < 9 // 9 = "weiß nicht" 10 = "k.A."
gen plSPD`c' = .
replace plSPD`c' = 1 if f15_`c' == 2
replace plSPD`c' = 0 if f15_`c' != 2 & f15_`c' < 9
}
// Dichotomisierung der Variablen zur Lösungskompetenz

foreach c in I II III IV {
lab var plSPD`c' "SPD: Problemlösungskompetenz, Zweitstimme"
lab var plUnion`c' "Union: Problemlösungskompetenz, Zweitstimme"
}
lab val pl* jn
 
* Tabelle 1
***********

// Der Variable "panel" kann entnommen worden, bis zu welcher Welle ein Befragter
// zur Verfügung stand. Aus der Häufigkeitsauszählung von "panel" lässt sich die
// Haltequote in Tabelle 1 wie folgt berechnen: 
// Bsp. Welle 2: Anzahl gesamte Befragte - Anzahl Befragte, die nur in Welle 1 
// befragt wurden / Anzahl gesamte Befragte
// also: (10027 - 1353) / 10027 = 86,5%

* Tabelle 2 
***********
// Tabelle 2 enthält Informationen dazu, wie viele Befragte Merkel und Schulz
// bestimmte Eigenschaften zuschreiben. Die Werte für die dokumentierten 56 
// Kombinationen (Kandidat*Welle*Eigenschaft) enstammen aus 56 
// Häufigkeitsauszählungen. Im Folgenden greifen wir für ein effizientes 
// Zusammenführen dieser Werte auf Matrizen zurück.

foreach a of numlist 2 3 {  
foreach b of numlist 1/7 {
foreach c in I II III IV {
tabcount f1`a'_`b'_`c'Bi, v1(1) matrix(tz`a'`b'`c')	 // Anz. Befr. "trifft zu"
tabcount f1`a'_`b'_`c'Bi, v1(0) matrix(tnz`a'`b'`c') // Anz. Befr. "trifft n. zu"
mat anz`a'`b'`c' = tz`a'`b'`c' + tnz`a'`b'`c'		 // Anz. Befr. gültige Antw.
mata: st_matrix("ant`a'`b'`c'", st_matrix("tz`a'`b'`c'") :/ st_matrix("anz`a'`b'`c'"))
// Anteil Befragter, die mit "trifft zu" antworteten  
}
}
}

mat ant_tab2 = ant21I,ant21II,ant21III,ant21IV,ant31I,ant31II,ant31III, ///
ant31IV\ant24I,ant24II,ant24III,ant24IV,ant34I,ant34II,ant34III,ant34IV\ ///
ant23I,ant23II,ant23III,ant23IV,ant33I,ant33II,ant33III,ant33IV\ ///
ant27I,ant27II,ant27III,ant27IV,ant37I,ant37II,ant37III,ant37IV\ /// 
ant25I,ant25II,ant25III,ant25IV,ant35I,ant35II,ant35III,ant35IV\ ///
ant22I,ant22II,ant22III,ant22IV,ant32I,ant32II,ant32III,ant32IV\ /// 
ant26I,ant26II,ant26III,ant26IV,ant36I,ant36II,ant36III,ant36IV	
// Zusammenführen der Anteilswerte in einer Matrix 

mat ant_proz_tab2 = ant_tab2 * 100 // Ermittlung der Anteile in Prozent

mat colnames ant_proz_tab2 = "AM_Welle 1" "AM_Welle 2" "AM_Welle 3" ///
"AM_Welle 4" "MS_Welle 1" "MS_Welle 2" "MS_Welle 3" "MS_Welle 4"
mat rownames ant_proz_tab2 = "Fuehrungsqualitaeten" "vertrauenswuerdig" ///
"Problemloesung" "Ausstrahlung" "klare Sprache" "gute Ideen" "engagierter Wahlk."
// Beschriftung der Matrix

esttab m(ant_proz_tab2, fmt(0)) using Rep_Ch7_tables.rtf, var(18) model(5) ///
nomtitles append  title("Tab. 2 Die Zuschreibung verschiedener Persoenlichkeitseigenschaften zu Angela Merkel und Martin Schulz im Verlauf der Panelbefragung (Prozent)")
// Ausgabe der Matrix als Tabelle in rtf-Datei

* Tabelle 3
***********
// Das Vorgehen bei Tabelle 2 und 3 entspricht einander. Da die Frage danach,
// ob Merkel/Schulz den besten Wahlkampf (f20) macht, in der ersten Welle noch 
// nicht erfasst wurde, muss die Anteilsberechung und Zuweisung zu Matrizen für 
// diese Variable separat erfolgen. 

foreach b in am ms {
foreach c in II III IV {
tabcount f20_`b'_`c', v1(1) matrix(tz20`b'`c')
tabcount f20_`b'_`c', v1(0) matrix(tnz20`b'`c')
mat anz20`b'`c' = tz20`b'`c' + tnz20`b'`c'
mata: st_matrix("ant20`b'`c'", st_matrix("tz20`b'`c'") :/ st_matrix("anz20`b'`c'"))
}
}

foreach a of numlist 17 18 {
foreach b in am ms {
foreach c in I II III IV {
tabcount f`a'_`b'_`c', v1(1) matrix(tz`a'`b'`c')
tabcount f`a'_`b'_`c', v1(0) matrix(tnz`a'`b'`c')
mat anz`a'`b'`c' = tz`a'`b'`c' + tnz`a'`b'`c'
mata: st_matrix("ant`a'`b'`c'", st_matrix("tz`a'`b'`c'") :/ st_matrix("anz`a'`b'`c'"))
}
}
}

mat ant_tab3 = .,.,ant20amII,ant20msII,ant20amIII,ant20msIII,ant20amIV, ///
ant20msIV\ant17amI,ant17msI,ant17amII,ant17msII,ant17amIII,ant17msIII, /// 
ant17amIV,ant17msIV\ant18amI,ant18msI,ant18amII,ant18msII,ant18amIII, ///
ant18msIII,ant18amIV,ant18msIV

mat ant_proz_tab3 = ant_tab3 * 100

mat colnames ant_proz_tab3 = "AM Welle 1" "AM Welle 2" "AM Welle 3" ///
"AM Welle 4" "MS Welle 1" "MS Welle 2" "MS Welle 3" "MS Welle 4"
mat rownames ant_proz_tab3 = "beste Wahlkampf" "beste Probleml." ///
"Kanzlerpraeferenz"

esttab m(ant_proz_tab3, fmt(0)) using Rep_Ch7_tables.rtf, var(18) model(5) ///
nomtitles append  title("Tab. 3 Der unmittelbare Vergleich von Angela Merkel und Martin Schulz im Verlauf der Panelbefragung (Prozent)")

* Tabelle 4
***********

* Modelle für Angela Merkel

foreach b of numlist 1/7 {
foreach c in I II III IV {
qui logit f18_am_`c' f12_`b'_`c'
// Regression nur mit Kandidateneigenschaft als UV (am0)
estadd coxsnell
// Cox & Snell R² muss gesondert aufgerufen werden
mat am0`b'`c' = e(coxsnell)
// Cox & Snell R² in Matrix gespeichert
qui logit f18_am_`c' piUnion`c' f12_`b'_`c'
// Regression mit Kandidateneigenschaft + Parteiidentifikation als UV (am2)
estadd coxsnell
mat am2`b'`c' = e(coxsnell)
qui logit f18_am_`c' piUnion`c'
// Regression nur mit Parteiidentifikation als UV (am1)
estadd coxsnell
mat am1`b'`c' = e(coxsnell)
mat am3`b'`c' = am2`b'`c' - am1`b'`c'
// Differenz aus am2 und am1 ergibt "vorsichtige Schätzung" des Effekts
// der Kandidateneigenschaft (am3)
}	
}

* Modelle für Martin Schulz

foreach b of numlist 1/7 {
foreach c in I II III IV {
qui logit f18_ms_`c' f13_`b'_`c'
estadd coxsnell
mat ms0`b'`c' = e(coxsnell)
qui logit f18_ms_`c' piSPD`c' f13_`b'_`c'
estadd coxsnell
mat ms2`b'`c' = e(coxsnell)
qui logit f18_ms_`c' piSPD`c'
estadd coxsnell
mat ms1`b'`c' = e(coxsnell)
mat ms3`b'`c' = ms2`b'`c' - ms1`b'`c'
}	
}

mat tab4 = am01I,am31I,ms01I,ms31I\am01II,am31II,ms01II,ms31II\ ///
am01III,am31III,ms01III,ms31III\am01IV,am31IV,ms01IV,ms31IV\ ///
am04I,am34I,ms04I,ms34I\am04II,am34II,ms04II,ms34II\ ///
am04III,am34III,ms04III,ms34III\am04IV,am34IV,ms04IV,ms34IV\ ///
am03I,am33I,ms03I,ms33I\am03II,am33II,ms03II,ms33II\ ///
am03III,am33III,ms03III,ms33III\am03IV,am33IV,ms03IV,ms33IV\ ///
am07I,am37I,ms07I,ms37I\am07II,am37II,ms07II,ms37II\ ///
am07III,am37III,ms07III,ms37III\am07IV,am37IV,ms07IV,ms37IV\ ///
am05I,am35I,ms05I,ms35I\am05II,am35II,ms05II,ms35II\ ///
am05III,am35III,ms05III,ms35III\am05IV,am35IV,ms05IV,ms35IV\ ///
am02I,am32I,ms02I,ms32I\am02II,am32II,ms02II,ms32II\ ///
am02III,am32III,ms02III,ms32III\am02IV,am32IV,ms02IV,ms32IV\ ///
am06I,am36I,ms06I,ms36I\am06II,am36II,ms06II,ms36II\ ///
am06III,am36III,ms06III,ms36III\am06IV,am36IV,ms06IV,ms36IV

mat colnames tab4 = "AM p2" "AM p2 nach PI" "MS p2" "MS p2 nach PI"
mat rownames tab4 = "W1 Fuehrungsqualitaeten" "W2 Fuehrungsqualitaeten" ///
"W3 Fuehrungsqualitaeten" "W4 Fuehrungsqualitaeten" "W1 vertrauenswuerdig" ///
"W2 vertrauenswuerdig" "W3 vertrauenswuerdig" "W4 vertrauenswuerdig" ///
"W1 Problemloesung" "W2 Problemloesung" "W3 Problemloesung" "W4 Problemloesung" ///
"W1 Ausstrahlung" "W2 Ausstrahlung" "W3 Ausstrahlung" "W4 Ausstrahlung" ///
"W1 klare Sprache" "W2 klare Sprache" "W3 klare Sprache" "W4 klare Sprache" ///
"W1 gute Ideen" "W2 gute Ideen" "W3 gute Ideen" "W4 gute Ideen" ///
"W1 engagierter Wahlk." "W2 engagierter Wahlk." "W3 engagierter Wahlk." "W4 engagierter Wahlk."

esttab m(tab4, fmt(3)) using Rep_Ch7_tables.rtf, var(21) model(11) ///
nomtitles append  title("Tab. 4 Erklaerungskraft der zugeschriebenen Persoenlichkeitseigenschaften fuer die Kanzlerpraeferenz zugunsten von Merkel bzw. Schulz (binaere logistische Regressionen)")

* Tabelle 5
***********

* Modelle für Angela Merkel

foreach c in I II III IV {
qui logit wUnion`c' f18_am_`c'
estadd coxsnell
mat t5am0`c' = e(coxsnell)
qui logit wUnion`c' piUnion`c' f18_am_`c'
estadd coxsnell
mat t5am2`c' = e(coxsnell)
qui logit wUnion`c' piUnion`c'
estadd coxsnell
mat t5am1`c' = e(coxsnell)
mat t5am3`c' = t5am2`c'-t5am1`c'
qui logit wUnion`c' piUnion`c' plUnion`c' f18_am_`c'
estadd coxsnell
mat t5am5`c' = e(coxsnell)
qui logit wUnion`c' piUnion`c' plUnion`c'
estadd coxsnell
mat t5am4`c' = e(coxsnell)
mat t5am6`c' = t5am5`c'-t5am4`c'
}	
// Ermittlung der (zusätzlichen) Erklärungskraft wie für Tab. 4. In Tab. 5 kommt 
// eine dritte Modellspezifikation hinaus. Daher werden am4, am5 und am6 benötigt.
// am4 = Regression mit Problemlösungskompetenz + Parteiidentifikation als UV
// am5 = Regression mit Problemlösungskompetenz + Parteiidentifikation 
// + Kanzlerpräferenz als UV
// am6 = Differenz aus am5 und am4 ergibt "vorsichtige Schätzung" des Effekts
// der Kanzlerpräferenz

* Modelle für Martin Schulz

foreach c in I II III IV {
qui logit wSPD`c' f18_ms_`c'
estadd coxsnell
mat t5ms0`c' = e(coxsnell)
qui logit wSPD`c' piSPD`c' f18_ms_`c'
estadd coxsnell
mat t5ms2`c' = e(coxsnell)
qui logit wSPD`c' piSPD`c'
estadd coxsnell
mat t5ms1`c' = e(coxsnell)
mat t5ms3`c' = t5ms2`c'-t5ms1`c'
qui logit wSPD`c' piSPD`c' plSPD`c' f18_ms_`c'
estadd coxsnell
mat t5ms5`c' = e(coxsnell)
qui logit wSPD`c' piSPD`c' plSPD`c'
estadd coxsnell
mat t5ms4`c' = e(coxsnell)
mat t5ms6`c' = t5ms5`c' - t5ms4`c'
}	

mat tab5 = t5am0I,t5am3I,t5am6I,t5ms0I,t5ms3I,t5ms6I\ ///
t5am0II,t5am3II,t5am6II,t5ms0II,t5ms3II,t5ms6II\ ///
t5am0III,t5am3III,t5am6III,t5ms0III,t5ms3III,t5ms6III\ ///
t5am0IV,t5am3IV,t5am6IV,t5ms0IV,t5ms3IV,t5ms6IV

mat colnames tab5 = "AM p2" "AM p2 nach PI" "AM p2 nach PI+Komp" "MS p2" "MS p2 nach PI" "MS p2 nach PI+Komp"
mat rownames tab5 = "Welle 1" "Welle 2" "Welle 3" "Welle 4"

esttab m(tab5, fmt(3)) using Rep_Ch7_tables.rtf, var(7) model(9) ///
nomtitles append  title("Tab. 5 Erklaerungskraft der Kanzlerpraeferenz fuer eine Wahlentscheidung zugunsten der Union bzw. der SPD bei der Bundestagswahl 2017 (binaere logistische Regressionen)")
